<?php
/**
 * Create/Reset Admin Account
 * Run this file once to create or reset your admin account
 * DELETE THIS FILE after use for security!
 */

require_once __DIR__ . '/config/db.php';

// Configuration
$email = 'admin@example.com';
$password = 'admin123'; // Change this to your desired password

try {
    $pdo = getDB();
    
    // Generate password hash
    $passwordHash = password_hash($password, PASSWORD_DEFAULT);
    
    // Check if admin exists
    $stmt = $pdo->prepare("SELECT id FROM admins WHERE email = ?");
    $stmt->execute([$email]);
    $existing = $stmt->fetch();
    
    if ($existing) {
        // Update existing admin
        $stmt = $pdo->prepare("UPDATE admins SET password_hash = ? WHERE email = ?");
        $stmt->execute([$passwordHash, $email]);
        echo "✅ Admin password updated successfully!\n";
        echo "Email: {$email}\n";
        echo "Password: {$password}\n";
    } else {
        // Create new admin
        $stmt = $pdo->prepare("INSERT INTO admins (email, password_hash) VALUES (?, ?)");
        $stmt->execute([$email, $passwordHash]);
        echo "✅ Admin account created successfully!\n";
        echo "Email: {$email}\n";
        echo "Password: {$password}\n";
    }
    
    echo "\n⚠️  IMPORTANT: Delete this file (create_admin.php) after use!\n";
    
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Please check your database configuration in config/db.php\n";
}
